// quickSort2.java
// Program demonstruje sortowanie metod quicksort, w ktrym
// osi podziau jest wybierana metod mediany trzech elementw
// Aby uruchomi ten program: C>java QuickSort2App
////////////////////////////////////////////////////////////////
class ArrayIns
   {
   private long[] theArray;          // odwoanie do tablicy theArray
   private int nElems;               // ilo elementw
//--------------------------------------------------------------
   public ArrayIns(int max)          // konstruktor
      {
      theArray = new long[max];      // tworzymy tablic
      nElems = 0;                    // pocztkowo pust
      }
//--------------------------------------------------------------
   public void insert(long value)    // dodanie elementu do tablicy
      {
      theArray[nElems] = value;      // wstawiamy element
      nElems++;                      // inkrementujemy wielko tablicy
      }
//--------------------------------------------------------------
   public void display()             // wywietlenie zawartoci tablicy
      {
      System.out.print("A=");
      for(int j=0; j<nElems; j++)    // dla kadego elementu
         System.out.print(theArray[j] + " ");  // wywietlamy go
      System.out.println("");
      }
//--------------------------------------------------------------
   public void quickSort()
      {
      recQuickSort(0, nElems-1);
      }
//--------------------------------------------------------------
   public void recQuickSort(int left, int right)
      {
      int size = right-left+1;
      if(size <= 3)                  // rczne sortowanie jeli tablica
         manualSort(left, right);    // jest dostatecznie maa
      else                           // w przeciwnym przypadku wykorzystujemy
         {                           // algorytm quicksort
         long median = medianOf3(left, right);
         int partition = partitionIt(left, right, median);
         recQuickSort(left, partition-1);
         recQuickSort(partition+1, right);
         }
      }  // koniec metody recQuickSort()
//--------------------------------------------------------------
   public long medianOf3(int left, int right)
      {
      int center = (left+right)/2;
                                         // kolejno elem.: lewego i rodkowego
      if( theArray[left] > theArray[center] )
         swap(left, center);
                                         // kolejno elem.: lewego i prawego
      if( theArray[left] > theArray[right] )
         swap(left, right);
                                         // kolejno elem.: rodkowego i prawego
      if( theArray[center] > theArray[right] )
         swap(center, right);

      swap(center, right-1);             // umieszczamy o podziau z prawej strony
      return theArray[right-1];          // zwracamy warto mediany
      }  // koniec metody medianOf3()
//--------------------------------------------------------------
   public void swap(int dex1, int dex2)  // zamienienie kolejnoci 2 elementw
      {
      long temp = theArray[dex1];        // zapisujemy A w temp
      theArray[dex1] = theArray[dex2];   // zapisujemy B w A
      theArray[dex2] = temp;             // zapisujemy temp w B
      }  // koniec metody swap(
//--------------------------------------------------------------
    public int partitionIt(int left, int right, long pivot)
       {
       int leftPtr = left;             // na prawo od pierwszego elementu
       int rightPtr = right - 1;       // na lewo od osi podziau

       while(true)
          {
          while( theArray[++leftPtr] < pivot )  // znajdujemy wikszy
             ;                                  //    (nic nie robimy)
          while( theArray[--rightPtr] > pivot ) // znajdujemy mniejszy
             ;                                  //    (nic nie robimy)
          if(leftPtr >= rightPtr)      // jeli kolejno wskanikw si zmieni,
             break;                    //    dzielimy dane
          else                         // kolejo nie ulega zmianie, a zatem
             swap(leftPtr, rightPtr);  // zamieniamy elementy
          }  // koniec ptli while(true)
       swap(leftPtr, right-1);         // przenosimy element stanowicy o podziau
       return leftPtr;                 // zwracamy indeks tego elementu
       }  // end partitionIt()
//--------------------------------------------------------------
   public void manualSort(int left, int right)
      {
      int size = right-left+1;
      if(size <= 1)
         return;         // sortowanie nie jest konieczne
      if(size == 2)
         {               // dwjkowe sortowanie elementw: left i right
         if( theArray[left] > theArray[right] ) 
            swap(left, right);
         return;
         }
      else               // size wynosi 3
         {               // trjkowe sortowanie elementw: left, center i right
         if( theArray[left] > theArray[right-1] )
            swap(left, right-1);                // left i center
         if( theArray[left] > theArray[right] )
            swap(left, right);                  // left i right
         if( theArray[right-1] > theArray[right] )
            swap(right-1, right);               // center i right
         }
      }  // koniec metody manualSort()
//--------------------------------------------------------------
   }  // koniec klasy ArrayIns
////////////////////////////////////////////////////////////////
class QuickSort2App
   {
   public static void main(String[] args)
      {
      int maxSize = 16;             // wielko tablicy
      ArrayIns arr;                 // odwoanie do tablicy
      arr = new ArrayIns(maxSize);  // tworzymy tablic

      for(int j=0; j<maxSize; j++)  // zapisujemy w tablicy 
         {                          // wartoci losowe
         long n = (int)(java.lang.Math.random()*99);
         arr.insert(n);
         }
      arr.display();                // wywietlamy tablic
      arr.quickSort();              // sortujemy je metod quicksort
      arr.display();                // ponownie wywietlamy tablic
      }  // koniec metody main()
   }  // koniec klasy QuickSort2App
////////////////////////////////////////////////////////////////
